/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.message;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.message.VWConsoleMsg;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class VWConsoleMsgDialog
extends VWModalDialog
implements ActionListener,
FocusListener {
    private Frame m_parent = null;
    private VWConsoleMsg m_message = null;
    private VWTaskTabPanel m_mainPanel = null;
    private JButton m_okButton = null;
    private JTextArea m_messageArea = null;
    private JLabel m_time = null;
    private JLabel m_source = null;
    private JLabel m_sourceIcon = null;
    private JLabel m_type = null;
    private JLabel m_typeIcon = null;
    private Border m_textBorder = null;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 250;

    public VWConsoleMsgDialog(Frame parent) throws Exception {
        super(parent);
        this.m_parent = parent;
        this.setTitle(VWResource.ConsoleMessage);
        this.getContentPane().setLayout(new BorderLayout());
        Dimension dim = VWStringUtils.stringToDimension("665,445");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(400, 250);
        }
        this.m_mainPanel = this.getMainPanel();
        this.getContentPane().add((Component)this.m_mainPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "Last");
    }

    public void displayMessage(VWConsoleMsg msg) {
        if (!this.isVisible()) {
            this.m_message = msg;
            this.m_time.setText(DateFormat.getDateTimeInstance().format(msg.getTime()));
            this.m_source.setText(msg.getSourceName());
            this.m_sourceIcon.setIcon(msg.getSourceIcon());
            this.m_type.setText(msg.getType());
            this.m_typeIcon.setIcon(msg.getTypeIcon());
            this.m_messageArea.setText(msg.getMessage());
            if (this.m_messageArea != null) {
                this.m_messageArea.requestFocus();
            }
            this.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        if (actionCMD.equals(VWTaskActionCommand.OK)) {
            this.setVisible(false);
        }
    }

    private VWTaskTabPanel getMainPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = new Insets(5, 10, 0, 5);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)new JLabel(VWResource.Time + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        this.m_time = new JLabel("");
        panel.add((Component)this.m_time, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)new JLabel(VWResource.Source + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        this.m_source = new JLabel("");
        this.m_sourceIcon = new JLabel(VWImageLoader.createImageIcon("unknode16.gif"), 2);
        panel.add((Component)this.m_source, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)new JLabel(VWResource.Type + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        this.m_type = new JLabel("");
        this.m_typeIcon = new JLabel(VWImageLoader.createImageIcon("unknode16.gif"), 2);
        panel.add((Component)this.m_type, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(20, 10, 5, 2);
        JLabel sMessage = new JLabel(VWResource.Message + ":");
        VWAccessibilityHelper.setAccessibility(sMessage, this, sMessage.getText(), sMessage.getText());
        panel.add((Component)sMessage, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, 10, 5, 5);
        this.m_messageArea = new JTextArea();
        this.m_messageArea.setRows(5);
        this.m_messageArea.setEditable(false);
        this.m_messageArea.setLineWrap(true);
        this.m_messageArea.setWrapStyleWord(true);
        this.m_messageArea.setBackground(this.getContentPane().getBackground());
        this.m_messageArea.addFocusListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_messageArea, this, this.m_messageArea.getText(), this.m_messageArea.getText());
        VWAccessibilityHelper.setLabelFor(sMessage, this.m_messageArea);
        panel.add((Component)new JScrollPane(this.m_messageArea, 20, 31), c);
        return panel;
    }

    private JPanel getIconLabelPanel(JLabel iconLabel, JLabel txtLabel) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 5);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 1;
        panel.add((Component)iconLabel, c);
        c.weightx = 1.0;
        c.gridx = 2;
        panel.add((Component)txtLabel, c);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setDoubleBuffered(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(8, 0, 8, 8);
        this.m_okButton = new JButton(VWResource.OK);
        this.m_okButton.setEnabled(true);
        this.m_okButton.addActionListener(this);
        this.m_okButton.setActionCommand(VWTaskActionCommand.OK);
        panel.add((Component)this.m_okButton, c);
        return panel;
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            this.m_textBorder = ((JComponent)source).getBorder();
            ((JComponent)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            ((JComponent)source).setBorder(this.m_textBorder);
        }
    }
}

